<?php
/**
 * Clickable Post Icons like Smilies
 * Arabic support www.mybbarab.com
 */
 

$plugins->add_hook("admin_config_post_icons_add_multiple", "clickableposticons_lowercase");
$plugins->add_hook("pre_output_page", "clickableposticons_run");


 
// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

function clickableposticons_info()
{
	return array(
		"name"				=> "هاك تفعيل الايقونات",
		"description"		=> "يقوم بتفعيل الايقونات في المواضيع من امكانية الضغط عليها واستخدامها",
		"website"			=> "",
		"author"			=> "ELY M.",
		"authorsite"		=> "",
		"version"			=> "1.0.3",
		"guid" => "f948325da8ceadcf763c6fc833c95231",
		"compatibility" => "*"
		);
}

function clickableposticons_activate()
{
}


function clickableposticons_deactivate()
{
}


function clickableposticons_lowercase() {

require_once MYBB_ROOT."/inc/class_datacache.php";
require_once MYBB_ROOT."/inc/class_plugins.php";
global $mybb, $lang, $db, $config, $cache, $plugins, $page, $form_container, $form, $icon;


	if($mybb->request_method == "post")
	{
		if($mybb->input['step'] == 1)
		{
			if(!trim($mybb->input['pathfolder']))
			{
				$errors[] = $lang->error_missing_path_multiple;
			}

			$path = $mybb->input['pathfolder'];
			$dir = @opendir(MYBB_ROOT.$path);
			if(!$dir)
			{
				$errors[] = $lang->error_invalid_path;
			}

			if(substr($path, -1, 1) !== "/")
			{
				$path .= "/";
			}

			$query = $db->simple_select("icons");
			while($icon = $db->fetch_array($query))
			{
				$aicons[$icon['path']] = 1;
			}

			while($file = readdir($dir))
			{
				if($file != ".." && $file != ".")
				{
					$ext = get_extension($file);
					if($ext == "gif" || $ext == "jpg" || $ext == "jpeg" || $ext == "png" || $ext == "bmp")
					{
						if(!$aicons[$path.$file])
						{
							$icons[] = $file;
						}
					}
				}
			}
			closedir($dir);

			if(count($icons) == 0)
			{
				$errors[] = $lang->error_no_images;
			}

			if(!$errors)
			{
				// We have no errors so let's proceed!
				$page->add_breadcrumb_item($lang->add_multiple_post_icons);
				$page->output_header($lang->post_icons." - ".$lang->add_multiple_post_icons);

				$sub_tabs['manage_icons'] = array(
					'title'	=> $lang->manage_post_icons,
					'link' => "index.php?module=config-post_icons"
				);

				$sub_tabs['add_icon'] = array(
					'title'	=> $lang->add_post_icon,
					'link' => "index.php?module=config-post_icons&amp;action=add"
				);

				$sub_tabs['add_multiple'] = array(
					'title' => $lang->add_multiple_post_icons,
					'link' => "index.php?module=config-post_icons&amp;action=add_multiple",
					'description' => $lang->add_multiple_post_icons_desc
				);

				$page->output_nav_tabs($sub_tabs, 'add_multiple');

				$form = new Form("index.php?module=config-post_icons&amp;action=add_multiple", "post", "add_multiple");
				echo $form->generate_hidden_field("step", "2");
				echo $form->generate_hidden_field("pathfolder", $path);

				$form_container = new FormContainer($lang->add_multiple_post_icons);
				$form_container->output_row_header($lang->image, array("class" => "align_center", 'width' => '10%'));
				$form_container->output_row_header($lang->name);
				$form_container->output_row_header($lang->add, array("class" => "align_center", 'width' => '5%'));

				foreach($icons as $key => $file)
				{
					$ext = get_extension($file);
					$find = str_replace(".".$ext, "", $file);
					$name = ":".$find.":";  //add : around filename for clickable post icons :)

					$form_container->output_cell("<img src=\"../".$path.$file."\" alt=\"\" /><br /><small>{$file}</small>", array("class" => "align_center", "width" => 1));
					$form_container->output_cell($form->generate_text_box("name[{$file}]", $name, array('id' => 'name', 'style' => 'width: 98%')));
					$form_container->output_cell($form->generate_check_box("include[{$file}]", 1, "", array('checked' => 1)), array("class" => "align_center"));
					$form_container->construct_row();
				}

				if($form_container->num_rows() == 0)
				{
					flash_message($lang->error_no_images, 'error');
					admin_redirect("index.php?module=config-post_icons&action=add_multiple");
				}

				$form_container->end();

				$buttons[] = $form->generate_submit_button($lang->save_post_icons);
				$form->output_submit_wrapper($buttons);

				$form->end();

				$page->output_footer();
				exit;
			}
		}
		else
		{
			$path = $mybb->input['pathfolder'];
			reset($mybb->input['include']);
			$name = $mybb->input['name'];

			if(empty($mybb->input['include']))
			{
				flash_message($lang->error_none_included, 'error');
				admin_redirect("index.php?module=config-post_icons&action=add_multiple");
			}

			foreach($mybb->input['include'] as $image => $insert)
			{
				if($insert)
				{
					$new_icon = array(
						'name' => $db->escape_string($name[$image]),
						'path' => $db->escape_string($path.$image)
					);

					$db->insert_query("icons", $new_icon);
				}
			}

			$cache->update_posticons();

			$plugins->run_hooks("admin_config_post_icons_add_multiple_commit");

			// Log admin action
			log_admin_action();

			flash_message($lang->success_post_icons_added, 'success');
			admin_redirect("index.php?module=config-post_icons");
		}
	}



}

function clickableposticons_run($page)
{
global $mybb, $lang, $config;


//code button add......
preg_match('#'.preg_quote('clickableEditor.bindSmilieInserter("clickable_smilies");').'#i', $page, $matches);
if($matches[0])
{
$page = str_replace($matches[0], "clickableEditor.bindSmilieInserter(\"clickable_icons\");\nclickableEditor.bindSmilieInserter(\"clickable_smilies\");", $page);
}

preg_match('#'.preg_quote('<td class="trow1" valign="top"><label><input type="radio" name="icon" value=').'#i', $page, $matches);
if($matches[0])
{
$page = str_replace($matches[0],"<td class=\"trow1\" valign=\"top\" id=\"clickable_icons\"><label><input type=\"radio\" name=\"icon\" value=", $page);
}

$page = preg_replace('#<label><input type="radio" name="icon" value="(.*?)" /> <img src="(.*?)" alt="(.*?)" /></label>#i', '<label><input type="radio" name="icon" value="$1" /> <img src="$2" alt="$3" class="smilie" /></label>', $page);


return $page;

}






?>
